# 通知設計書 4-Syslog NOTICE通知（停止）

## 概要

本ドキュメントは、Horse WebフレームワークのDaemonプロバイダーにおけるSyslog NOTICE通知（停止）機能の設計を記述する。デーモンプロセス停止時にシステムログへ停止通知を記録する機能である。

### 本通知の処理概要

本通知は、LinuxデーモンとしてHorseサーバーが停止する際に、システムログファシリティを通じて停止完了情報を記録する機能を提供する。

**業務上の目的・背景**：Linuxサーバー環境でデーモンとして動作するWebサーバーの運用において、サーバーの停止状態をシステムログに記録することは運用監視の基本要件である。この通知により、システム管理者はsyslogを通じてサーバーの正常停止を確認でき、監視ツールによる停止検知やログ分析が可能となる。計画停止か異常停止かの判断材料となる。

**通知の送信タイミング**：デーモンプロセスのメインループが終了し、syslogを閉じる直前に送信される。正常終了時（FRunningがFalseになりループ終了）と、例外発生後の終了時の両方で実行される。

**通知の受信者**：システムログデーモン（syslogd/rsyslogd）を経由して、ログファイル（通常は`/var/log/daemon.log`または`/var/log/messages`）に記録される。受信者はシステム管理者、運用監視システム、ログ分析ツールである。

**通知内容の概要**：固定メッセージ「daemon stopped」が記録される。

**期待されるアクション**：システム管理者はサーバーが停止したことを確認できる。監視システムは停止イベントを検知し、必要に応じてアラートを発報または抑止する。

## 通知種別

システムログ（Syslog） - LOG_NOTICE優先度

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | NOTICE（LOG_NOTICE = 5） |
| リトライ | 無し |

### 送信先決定ロジック

syslogシステムコールにより、OSのシステムログデーモンに送信される。ログのルーティングはsyslog設定（`/etc/rsyslog.conf`等）に従う。ファシリティは`LOG_DAEMON`（デーモン関連メッセージ）が使用される。

## 通知テンプレート

### システムログ通知の場合

| 項目 | 内容 |
|-----|------|
| ファシリティ | LOG_DAEMON（3 << 3 = 24） |
| 優先度 | LOG_NOTICE（5） |
| オプション | LOG_PID \| LOG_NDELAY |
| 形式 | テキスト |

### 本文テンプレート

```
daemon stopped
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | システムログ通知のため添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | - | 固定メッセージのため変数なし | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| デーモン停止 | InternalListenメソッド終了処理 | 常に送信（finally相当の位置） | メインループ終了後、closelog前に送信 |
| SIGTERMシグナル | FRunning=Falseによりループ終了 | SIGTERMでFRunningがFalseになった場合 | kill {pid}またはsystemctl stop等で発生 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非デーモンモード | HORSE_DAEMONが定義されていない場合は本コードは実行されない |
| openlog前の異常終了 | syslog初期化前にエラーが発生した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[デーモン実行中] --> B{終了条件?}
    B -->|SIGTERMシグナル| C[HandleSignalsでFRunning=False]
    B -->|例外発生| D[例外処理]
    C --> E[イベントループ終了]
    D --> E
    E --> F[Syslog LOG_NOTICE daemon stopped]
    F --> G[closelog]
    G --> H[FEvent.Free]
    H --> I[プロセス終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| syslog送信失敗 | syslogデーモンが停止している場合 | OSレベルで処理されるため、アプリケーション側での対処は不要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（通常は停止時1回のみ） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

デーモン停止時に即座に送信される。時間帯の制限はない。

## セキュリティ考慮事項

- 固定メッセージのみをログに記録するため、機密情報の漏洩リスクはない
- syslogへの書き込み権限はOSレベルで管理される
- 停止ログは計画停止と異常停止の区別に役立つ

## 備考

- `HORSE_DAEMON`コンパイラディレクティブが定義されている場合のみ有効
- 正常終了と例外発生後の終了の両方で送信される（行275がtry-exceptの後、closelogの前に位置）
- SIGTERMシグナル受信時はHandleSignals内でFRunning=False設定後、メインループが終了してこの通知が送信される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

syslog優先度と停止フローの関係を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | LOG_NOTICE定数（行61、値=5）を確認 |
| 1-2 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | FRunningフラグ（行68）の役割を確認 |

**読解のコツ**: LOG_NOTICEは「正常だが重要な状態」を示す。停止は正常な運用イベントなのでERRではなくNOTICEを使用。

#### Step 2: エントリーポイントを理解する

停止処理のフローと通知送信位置を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | InternalListenメソッド終了部分（行265-279）を確認 |

**主要処理フロー**:
1. **行265-266**: `while FRunning do FEvent.WaitFor()` - メインループ
2. **行267**: `ExitCode := EXIT_SUCCESS` - 正常終了コード設定
3. **行275**: `Syslog(LOG_NOTICE, 'daemon stopped')` - **ここがNOTICE通知の送信箇所**
4. **行276**: `closelog()` - syslog終了
5. **行278**: `FEvent.Free` - イベントオブジェクト解放

#### Step 3: SIGTERMとの連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | HandleSignals内のSIGTERM処理（行96-100）を確認 |

**主要処理フロー**:
- **行96-100**: SIGTERM受信時
  - `FRunning := False` - ループ終了フラグ
  - `FEvent.SetEvent` - WaitForを解除
- これによりメインループが終了し、行275の停止通知が送信される

### プログラム呼び出し階層図

```
[シグナルまたは正常終了]
    │
    ▼
HandleSignals (SIGTERMの場合)
    │
    ├─ FRunning := False (行98)
    │
    └─ FEvent.SetEvent (行99)
           │
           ▼
THorseProvider.InternalListen (行195)
    │
    ├─ while FRunning do (行265)
    │      FEvent.WaitFor() (行266)
    │      [ループ終了]
    │
    ├─ ExitCode := EXIT_SUCCESS (行267)
    │      または
    │  ExitCode := EXIT_FAILURE (行272, 例外時)
    │
    ├─ Syslog(LOG_NOTICE, 'daemon stopped') (行275)
    │      │
    │      └─ ThirdParty.Posix.Syslog.Syslog
    │             │
    │             └─ _syslog (libc)
    │
    └─ closelog() (行276)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

SIGTERMシグナル    ───┬──▶ FRunning := False          ───▶ syslog
または                 │           │                          /var/log/daemon.log
メインループ終了       │           ▼
                      │    FEvent.SetEvent
                      │           │
                      │           ▼
                      │    while FRunning終了
                      │           │
                      │           ▼
                      │    固定メッセージ生成
                      │    "daemon stopped"
                      │           │
                      └───────────▼
                           Syslog(LOG_NOTICE, message)
                                  │
                                  ▼
                           _syslog(LOG_NOTICE, ...)
                                  │
                                  ▼
                           closelog()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | ソース | デーモンプロバイダーのメイン実装、停止通知の送信元 |
| ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | ソース | syslog APIのDelphiラッパー、LOG_NOTICE定数定義 |
